/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class VinesGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.f_57834_, VineBlock.f_57836_, VineBlock.f_57837_, VineBlock.f_57835_};
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer("max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block("block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block("tip_block");
    public static final ConfigurationProperty<VineType> VINE_TYPE = ConfigurationProperty.property("vine_type", VineType.class);

    public VinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(QUANTITY, MAX_LENGTH, VERTICAL_SPREAD, RAY_DISTANCE, BLOCK, TIP_BLOCK, VINE_TYPE, FRUITING_RADIUS);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(QUANTITY, 4)).with(MAX_LENGTH, 8)).with(VERTICAL_SPREAD, Float.valueOf(60.0f))).with(RAY_DISTANCE, Float.valueOf(5.0f))).with(BLOCK, Blocks.f_50191_)).with(TIP_BLOCK, null)).with(VINE_TYPE, VineType.SIDE)).with(FRUITING_RADIUS, -1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen() || context.endPoints().isEmpty()) {
            return false;
        }
        VineType vineType = configuration.get(VINE_TYPE);
        int quantity = (Integer)configuration.get(QUANTITY);
        block4: for (int i = 0; i < quantity; ++i) {
            BlockPos endPoint = context.endPoints().get(context.random().m_188503_(context.endPoints().size()));
            switch (vineType) {
                case SIDE: {
                    this.addSideVines(configuration, context.level(), context.species(), context.pos(), endPoint, context.bounds(), true);
                    continue block4;
                }
                case CEILING: 
                case FLOOR: {
                    this.addVerticalVines(configuration, context.level(), context.species(), context.pos(), endPoint, context.bounds(), true);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        int fruitingRadius = (Integer)configuration.get(FRUITING_RADIUS);
        if (fruitingRadius < 0 || context.fertility() < 1) {
            return false;
        }
        BlockState blockState = level.m_8055_(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && branch.getRadius(blockState) >= fruitingRadius && context.natural() && species.seasonalFruitProductionFactor(context.levelContext(), rootPos) > level.m_213780_().m_188501_()) {
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot(level, rootPos, new MapSignal(endFinder));
            List<BlockPos> endPoints = endFinder.getEnds();
            int qty = (Integer)configuration.get(QUANTITY);
            if (!endPoints.isEmpty()) {
                for (int i = 0; i < qty; ++i) {
                    BlockPos endPoint = endPoints.get(level.m_213780_().m_188503_(endPoints.size()));
                    if (configuration.get(VINE_TYPE) == VineType.SIDE) {
                        this.addSideVines(configuration, level, species, rootPos, endPoint, SafeChunkBounds.ANY, false);
                        continue;
                    }
                    this.addVerticalVines(configuration, level, species, rootPos, endPoint, SafeChunkBounds.ANY, false);
                }
                return true;
            }
        }
        return true;
    }

    protected void addSideVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds, boolean worldgen) {
        BlockHitResult result = CoordUtils.branchRayTrace(level, species, rootPos, branchPos, 90.0f, ((Float)configuration.get(VERTICAL_SPREAD)).floatValue(), ((Float)configuration.get(RAY_DISTANCE)).floatValue(), safeBounds);
        if (result == null) {
            return;
        }
        BlockPos vinePos = result.m_82425_().m_121945_(result.m_82434_());
        if (vinePos == BlockPos.f_121853_ || !safeBounds.inBounds(vinePos, true)) {
            return;
        }
        BooleanProperty vineSide = this.sideVineStates[result.m_82434_().m_122424_().ordinal()];
        if (vineSide == null) {
            return;
        }
        BlockState vineState = (BlockState)configuration.get(BLOCK).m_49966_().m_61124_((Property)vineSide, (Comparable)Boolean.valueOf(true));
        this.placeVines(level, vinePos, vineState, configuration.get(MAX_LENGTH), null, configuration.get(VINE_TYPE), worldgen);
    }

    protected void addVerticalVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds, boolean worldgen) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos(level, species, rootPos, branchPos, safeBounds);
        if (!safeBounds.inBounds(vinePos, true)) {
            return;
        }
        if (configuration.get(VINE_TYPE) == VineType.FLOOR) {
            vinePos = this.findGround(level, vinePos);
        }
        if (vinePos == BlockPos.f_121853_) {
            return;
        }
        this.placeVines(level, vinePos, configuration.get(BLOCK).m_49966_(), configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(block -> (BlockState)block.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(worldgen ? 25 : 0))).orElse(null), configuration.get(VINE_TYPE), worldgen);
    }

    private BlockPos findGround(LevelAccessor level, BlockPos vinePos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.m_123341_(), vinePos.m_123342_(), vinePos.m_123343_());
        do {
            mPos.m_122173_(Direction.DOWN);
            if (mPos.m_123342_() > 0) continue;
            return BlockPos.f_121853_;
        } while (level.m_46859_(vinePos) || level.m_8055_(vinePos).m_60734_() instanceof DynamicLeavesBlock);
        return mPos.m_7494_();
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, VineType vineType, boolean worldGen) {
        int len = worldGen ? Mth.m_14045_((int)(level.m_213780_().m_188503_(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.m_123341_(), vinePos.m_123342_(), vinePos.m_123343_());
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            if (!level.m_46859_((BlockPos)mPos)) {
                if (i <= 0 || vineType == VineType.SIDE) break;
                mPos.m_142448_(mPos.m_123342_() + (vineType == VineType.FLOOR ? -1 : 1));
                level.m_7731_((BlockPos)mPos, tipState, 3);
                break;
            }
            level.m_7731_((BlockPos)mPos, i == len - 1 ? tipState : vinesState, 3);
            mPos.m_142448_(mPos.m_123342_() + (vineType == VineType.FLOOR ? 1 : -1));
        }
    }

    public static enum VineType {
        CEILING,
        FLOOR,
        SIDE;

    }
}

